/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeEmitter;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumDoubleStackList;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.mixin.block.hopper.DoubleInventoryAccessor;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;

public class LithiumDoubleInventory
extends class_1258
implements LithiumInventory,
InventoryChangeTracker,
InventoryChangeEmitter,
InventoryChangeListener,
ComparatorTracker {
    private final LithiumInventory first;
    private final LithiumInventory second;
    private LithiumStackList doubleStackList;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = null;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryHandlingTypeListeners = null;

    public static LithiumDoubleInventory getLithiumInventory(class_1258 doubleInventory) {
        class_1263 vanillaSecond;
        class_1263 vanillaFirst = ((DoubleInventoryAccessor)doubleInventory).getFirst();
        if (vanillaFirst != (vanillaSecond = ((DoubleInventoryAccessor)doubleInventory).getSecond()) && vanillaFirst instanceof LithiumInventory) {
            LithiumInventory first = (LithiumInventory)vanillaFirst;
            if (vanillaSecond instanceof LithiumInventory) {
                LithiumInventory second = (LithiumInventory)vanillaSecond;
                LithiumDoubleInventory newDoubleInventory = new LithiumDoubleInventory(first, second);
                LithiumDoubleStackList doubleStackList = LithiumDoubleStackList.getOrCreate(newDoubleInventory, InventoryHelper.getLithiumStackList(first), InventoryHelper.getLithiumStackList(second), newDoubleInventory.method_5444());
                newDoubleInventory.doubleStackList = doubleStackList;
                return doubleStackList.doubleInventory;
            }
        }
        return null;
    }

    private LithiumDoubleInventory(LithiumInventory first, LithiumInventory second) {
        super((class_1263)first, (class_1263)second);
        this.first = first;
        this.second = second;
    }

    @Override
    public void emitContentModified() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null) {
            for (InventoryChangeListener inventoryChangeListener : inventoryChangeListeners) {
                inventoryChangeListener.handleInventoryContentModified(this);
            }
            inventoryChangeListeners.clear();
        }
    }

    @Override
    public void emitStackListReplaced() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        this.inventoryHandlingTypeListeners = null;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(inventoryChangeListener -> inventoryChangeListener.handleStackListReplaced(this));
        }
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = listeners;
        }
        this.invalidateChangeListening();
    }

    @Override
    public void emitRemoved() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        this.inventoryHandlingTypeListeners = null;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(listener -> listener.handleInventoryRemoved(this));
        }
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = listeners;
        }
        this.invalidateChangeListening();
    }

    private void invalidateChangeListening() {
        LithiumStackList lithiumStackList;
        if (this.inventoryChangeListeners != null) {
            this.inventoryChangeListeners.clear();
        }
        if ((lithiumStackList = this.doubleStackList) != null) {
            lithiumStackList.removeInventoryModificationCallback(this);
        }
    }

    @Override
    public void emitFirstComparatorAdded() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null && !inventoryChangeListeners.isEmpty()) {
            inventoryChangeListeners.removeIf(inventoryChangeListener -> inventoryChangeListener.handleComparatorAdded(this));
        }
    }

    @Override
    public void forwardContentChangeOnce(InventoryChangeListener inventoryChangeListener, LithiumStackList stackList, InventoryChangeTracker thisTracker) {
        if (this.inventoryChangeListeners == null) {
            this.inventoryChangeListeners = new ReferenceOpenHashSet(1);
        }
        stackList.setInventoryModificationCallback(thisTracker);
        this.inventoryChangeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void forwardMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = new ReferenceOpenHashSet(1);
        }
        if (this.inventoryHandlingTypeListeners.isEmpty()) {
            ((InventoryChangeTracker)((Object)this.first)).listenForMajorInventoryChanges(this);
            ((InventoryChangeTracker)((Object)this.second)).listenForMajorInventoryChanges(this);
        }
        this.inventoryHandlingTypeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void stopForwardingMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners != null) {
            this.inventoryHandlingTypeListeners.remove((Object)inventoryChangeListener);
            if (this.inventoryHandlingTypeListeners.isEmpty()) {
                ((InventoryChangeTracker)((Object)this.first)).stopListenForMajorInventoryChanges(this);
                ((InventoryChangeTracker)((Object)this.second)).stopListenForMajorInventoryChanges(this);
            }
        }
    }

    @Override
    public class_2371<class_1799> getInventoryLithium() {
        return this.doubleStackList;
    }

    @Override
    public void setInventoryLithium(class_2371<class_1799> inventory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleInventoryContentModified(class_1263 inventory) {
        this.emitContentModified();
    }

    @Override
    public void handleInventoryRemoved(class_1263 inventory) {
        this.emitRemoved();
    }

    @Override
    public boolean handleComparatorAdded(class_1263 inventory) {
        this.emitFirstComparatorAdded();
        return this.inventoryChangeListeners.isEmpty();
    }

    @Override
    public void onComparatorAdded(class_2350 direction, int offset) {
        throw new UnsupportedOperationException("Call onComparatorAdded(Direction direction, int offset) on the inventory half only!");
    }

    @Override
    public boolean hasAnyComparatorNearby() {
        return ((ComparatorTracker)((Object)this.first)).hasAnyComparatorNearby() || ((ComparatorTracker)((Object)this.second)).hasAnyComparatorNearby();
    }
}

